---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-next export

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - なし。全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/cli/next-export.ts` - next exportコマンドの実装（15行）
- E-02: `packages/next/src/bin/next.ts` - CLIエントリーポイント（344-347行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | next exportは廃止済みコマンド | E-01 (4-12行目) | ○ |
| C-02 | output: 'export'への移行案内メッセージを表示 | E-01 (6-8行目) | ○ |
| C-03 | process.exit(1)で終了 | E-01 (11行目) | ○ |
| C-04 | CLIでhidden: trueとして登録 | E-02 (345行目) | ○ |
| C-05 | helpOptionはfalse | E-02 (347行目) | ○ |
| C-06 | ドキュメントURLの提示 | E-01 (7行目) | ○ |
| C-07 | パラメータを受け付けない | E-02 (346行目, actionのみ) | ○ |
| C-08 | cyan()でURLをハイライト | E-01 (1行目, 7行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。本機能は非常にシンプルで、全主張の根拠が確認できている。

## 5) リスクフラグ（レビュー観点）
- 0: 非常にシンプルな実装であり、リスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] エラーメッセージの内容が最新のドキュメントURLと一致しているか
- [ ] hidden: trueが正しく設定されているか
